/* Eieruhr */

// #include (IRQ-Zeuch, Standardkram)
//#include <inttypes.h>
#include <avr/pgmspace.h>
#include <avr/signal.h>
#include <avr/interrupt.h>
//#include <string.h>
//#include <stdio.h>
#include <avr/io.h>

#define TMC8_CK			  (_BV(CS00))
#define TMC8_CK8		  (_BV(CS01))
#define TMC8_CK64     (_BV(CS00)+_BV(CS01))
#define TMC8_CK256		(_BV(CS02))
#define TMC8_CK1024		(_BV(CS00)+_BV(CS02))

// character sets for time display
// NOR
__attribute__ ((progmem)) unsigned char fn_NOR[]={0xd5,0x46,0x00,0x46,0x91,0x48,0x11,0x0e,0x06,0x4c,0x17,0x20,0x57,0x0c,0x81,0x02,0x57,0x4c,0x17,0x4c};
// MIA
__attribute__ ((progmem)) unsigned char fn_MIA[]={0xc4,0x46,0x00,0x06,0x91,0x40,0x01,0x0e,0x06,0x0c,0x15,0x20,0x55,0x0c,0x81,0x00,0x55,0x4c,0x17,0x44};

// global variables
volatile unsigned char time[3]={0,0,0};  // current time
volatile unsigned char flags[3]={0,0,0}; // blink and cursor flags
volatile unsigned char display[12];      // display buffer
volatile unsigned char altered=0;        // flag for display actualization
volatile unsigned char keys=0xff;        // keypad mirror
volatile int font; // current font;
PGM_P  fonts[]={fn_NOR,fn_MIA,0};

void shiftbyte(unsigned char c)
{
	unsigned char mask=0x80;
	while (mask)
	{
		if (mask&c)
		  PORTB|=0x40; // set data line
		else
		  PORTB&=0xbf; // reset data line
		PORTB|=0x80;   // toggle clock line
		mask>>=1;
		PORTB&=0x7f;
	}
}

// Time counting (Timer0-ISR)
INTERRUPT(SIG_OVERFLOW0)
{
	static int stelle=0;
	static int prescale=0;
	static char mux=0;
	int ch,col;
	
  if ((prescale++)>2047)
  {
  	prescale=0;
    time[0]++;
    if (time[0]>59) 
    {
    	time[0]=0;
     	time[1]++;
     	if (time[1]>59)
     	{
     		time[1]=0;
     		time[2]++;
     		if (time[2]>23) time[2]=0;
     	}
    }
    altered=1;
  }
  if (altered)
  {
    ch=(time[0]%10)<<1;
    display[0]=PRG_RDB(font+ch); ch++;
    display[1]=PRG_RDB(font+ch); ch++;
    ch=(time[0]/10)<<1;
    display[2]=PRG_RDB(font+ch); ch++;
    display[3]=PRG_RDB(font+ch); ch++;

    ch=(time[1]%10)<<1;
    display[4]=PRG_RDB(font+ch); ch++;
    display[5]=PRG_RDB(font+ch); ch++;
    ch=(time[1]/10)<<1;
    display[6]=PRG_RDB(font+ch); ch++;
    display[7]=PRG_RDB(font+ch); ch++;

    ch=(time[2]%10)<<1;
    display[8]=PRG_RDB(font+ch); ch++;
    display[9]=PRG_RDB(font+ch); ch++;
    ch=(time[2]/10)<<1;
    display[10]=PRG_RDB(font+ch); ch++;
    display[11]=PRG_RDB(font+ch); ch++;
    altered=0;
  }
  
  // muxing 
  if ((mux++)>3)
  {
  	keys=PIND;
  	mux=0;
  	col=stelle>>2;
    shiftbyte(display[stelle++]);
  	shiftbyte(display[stelle++]|(flags[col]&1?0x10:0));
  	shiftbyte(display[stelle++]);
  	shiftbyte(display[stelle++]|(flags[col]&1?0x10:0));
  	PORTB&=0xf8;          // display off
  	sbi(PORTB,4);         // set strobe line
  	asm("nop");
  	cbi(PORTB,4);         // reset strobe line
  	if ((~flags[col]&2) || (prescale>512))
      PORTB|=1<<col;        // activate column

//  	  PORTB&=0xf8;           // display off

    if (stelle>11) stelle=0;
  }
}

	
int main(void)
{
	char mode=0;
	int  fn=0;
  DDRB=0xd7;
  DDRD=0x00;
  PORTB=0xd0;
  PORTD=0xff;

  font=fonts[fn];

  // start timer 0 for muxing and time counting
  TCCR0 = TMC8_CK8;  // prescaler = 1024
  TIMSK = _BV(TOIE0);
  
  sei();
  while (1)
  {
    if bit_is_clear(keys,6)
    {
    	// select mode
    	if (mode)
    	  mode--;
    	else
    	  mode=3;  
   		flags[0]=flags[1]=flags[2]=0;
  	  if (mode)
 	      flags[mode-1]=2;  // blink edited digit 
  	  while (bit_is_clear(keys,6));    
    }
    if (bit_is_clear(keys,4))
    {
    	if (mode)
    	{
    		// set time
    	  if (mode==1)
    	    time[mode-1]=0;
    	  else
    	    time[mode-1]++;
    	  if (((mode==3) && (time[mode-1]>23)) || (time[mode-1]>59)) time[mode-1]=0;
      }
      else
      {
      	// select font
        if (!fonts[++fn]) fn=0;
        font=fonts[fn];
      }
    	altered=1;
  	  while (bit_is_clear(keys,4));    
    }
    	
  }
}
