/* Eieruhr */

// #include (IRQ-Zeuch, Standardkram)
//#include <inttypes.h>
#include <avr/pgmspace.h>
#include <avr/signal.h>
#include <avr/interrupt.h>
//#include <string.h>
//#include <stdio.h>
#include <avr/io.h>

// #define (mal sehen)

// global variables
volatile unsigned char time[4]={0,0,0,0};
volatile unsigned char flags[3]={0,0,0};

// Multiplexroutine (Timer-ISR)
//void mux(void)
INTERRUPT(SIG_OVERFLOW0)
{
	static int stelle=0;
	static int prescale=0;
	static int dekatron=1;
	char zehner,einer;
	volatile char delay;
  TCNT0 = 0x80;
  prescale++;
//  if (prescale==20)
//   	PORTD=(PORTD&0xf0)|(1<<dekatron);
  if (prescale>=10)
  {
  	prescale=0;
  	if (!(time[3]&1))
  	{
      if (time[3]==0)
      {
      	PORTD=(PORTD&0xf0)|1;
      	dekatron=0;
      }	
      else
      {
      	dekatron++;
      	if (dekatron>3) dekatron=1;
   //   	PORTD|=(1<<dekatron);
      	PORTD=(PORTD&0xf0)|(1<<dekatron);
      }
    }
  	time[3]++;
  	if (time[3]>59)
  	{
  		time[3]=0;
      time[0]++;
      OCR1AL = time[0]<<2;
      OCR1BL = time[0]<<2;
      if (time[0]>59) 
      {
      	dekatron=0;
      	time[0]=0;
      	time[1]++;
      	if (time[1]>59)
      	{
      		time[1]=0;
      		time[2]++;
      		if (time[2]>23) time[2]=0;
      	}
      }
    }
  }
	zehner=time[stelle]/10;
	einer=time[stelle]%10;
	PORTB=0;                // display off
  PORTA=0;
  PORTC=0;
  if (!flags[stelle] || (time[3]<50))
  {
	  if (einer<8)
	  {
      PORTA=128>>einer;       // activate column
      PORTC=128>>(zehner+2);
    }
    else
    {
      PORTA=0;
      PORTC=(128>>(einer-8))+(128>>(zehner+2));
    }
    PORTB=4>>stelle;
  }
  stelle++;
  if (stelle>2) stelle=0;
}

	
/*
 * Startup Timer2 ISR for muxing the panel
 */
void startTimer(void)
{
	/* start Timer 1 for PWM to bargraph tube */
  TCCR1A=0xA1;  
  TCCR1B=0x01;  
  TCNT1H=0x00;  
  TCNT1L=0x00;
  OCR1AH=0x00;
  OCR1AL=0x00; 
  OCR1BH=0x00;
  OCR1BL=0x00; 
  //SETBIT(DDRD, 5);
  //SETBIT(DDRD, 4);

  /* set timer 2 to CTC mode, clock / 256 = 16uS */
  TCCR0 = BV(CS00) | BV(CS01);
  /* enable the output compare match interrupt */
  TIMSK |= BV(TOIE0);
  sei();
}
	  
int main(void)
{
	char mode=0;
  DDRA=0xFF;
  DDRB=0xFF;
  DDRC=0xFF;
  DDRD=0xFF;  /* All bits except TxD are input */
  PORTA=0x00;
  PORTB=0x00;
  PORTC=0x00;
  PORTD=0xf1; /* Pullups on */ 
  startTimer();
  while (1)
  {
  	
    if bit_is_clear(PIND,7)
    {
    	if (mode)
    	  mode--;
    	else
    	  mode=3;  
   		flags[0]=flags[1]=flags[2]=0;
  	  if (mode)
 	      flags[mode-1]=0xff;  // blink edited digit 
  	  while (bit_is_clear(PIND,7));    
    }
    if (mode && bit_is_clear(PIND,6))
    {
    	if (mode==1)
    	  time[mode-1]=0;
    	else
    	  time[mode-1]++;
    	if (((mode==3) && (time[mode-1]>23)) || (time[mode-1]>59)) time[mode-1]=0;
  	  while (bit_is_clear(PIND,6));    
    }
    	
  }
}
