{$A+,B-,D+,E+,F-,G+,I+,L+,N-,O-,P+,Q+,R+,S+,T+,V+,X+}
{$M 16384,0,655360}
program mklink;
{Builds a Joliet Directory Link Table from all Joliet CDs in all drives.
 This table has following content:
 - 1 DWORD size designator (=4)
 - 1 DWORD number of entries (=n)
 - n DWORD Joliet directory sectors
 - n DWORD ISO corresponding directory sectors
 The name is built from CD ISO label, using numbers&letters, +.JLT extension

 This generator program has some limitations:
 - every directory must be less than 64K (runtime error 220)
   (relax this requires huge pointer arithmetics. Loading single
    sectors would degrade MKLINKs performance dramatically.
    Huge pointers are easy if allocated memory has offset of zero.)
 - directory data for all levels must fit into DOS memory (runtime error 203)
   (ISO resticts depth to eight levels, but most writer software
    can relax this limitation. You may recompile using Borland DPMI.)
 - CD distinction relies on the first eight letters&numbers of volume name
   (This limitation is also built into future DOSLFN 0.33.)
 - Empty directories may not be mapped together as intended
   (This is by design of Joliet - a better implementation can compare strings
    to get better results, but for normal usage, malfunction is meaningless.)

 The "force mode" includes:
 - Taking all given drive letters as MSCDEX letters (do not check them)
 - Skipping "CeQuadrat Joliet Directory Link Table", burned by WinOnCD
 - Overwriting existing files (do not skip if they exist)

 Unreadable and Non-Joliet CDs are always skipped.

 Freeware 10/01 haftmann#software}

uses Dos,WinDos,Strings;
{WinDos  for GetArgCount and GetArgStr}
{Strings for StrCopy, StrPas, StrScan...}

type
 LongRec=record
  lo,hi:Word;
 end;
 PWord=^Word;
 PLongInt=^LongInt;

var
 drv: Word;
 verbosity: Integer;
 forcemode: Boolean;	{enforce overwriting file and ignoring CeQuadrat}
 batchmode: Boolean;	{continue manually changing discs until done}
 contmode: Boolean;	{if at first time no disc in a closed drive, eject}
 timer: Word absolute $40:$6C;	{18.2 ms per increment}

function GetVToc(Nr:Integer; sec:PChar):Boolean; assembler;
{Reads one of a VTOC (Table Of Content) sector}
 asm	les	bx,[sec]
	mov	cx,[drv]
	mov	dx,[Nr]
	mov	ax,1505h
	int	2Fh
	mov	al,1
	sbb	al,0
 end;

function ReadSectors(sec:PChar; cnt:Word; Nr:LongInt):Boolean; assembler;
{Reads some CD sectors; may include VTOC sectors at #16+ depending on
 (MS)CDEX running; parameter sorting compatible to Int25/Int26 call}
 asm	les	bx,[sec]
	mov	si,LongRec[Nr].hi
	mov	di,LongRec[Nr].lo
	mov	cx,[drv]
	mov	dx,[cnt]
	mov	ax,1508h
	int	2Fh
	mov	al,1
	sbb	al,0
 end;

procedure Idle; assembler;
{releases current time slice to Virtual Machine Manager (Windows, OS/2),
 and give DOS and TSRs a hint to do some backgound processing}
 asm	int	28h
	mov	ax,1680h	{release time slice (PM)}
	int	2Fh
	mov	ah,0Bh		{check input status (^C)}
	int	21h
 end;

function Ioctl(s:PChar):Boolean;
{Maintain a CD IOCTL call (with its brain-damaged structure),
 String <s> must contain:
 s[0]=control code (3=read, 12=write)
 s[1]=number of bytes to read or write
 s[2+]=bytes to write or (return) bytes ro read}
 type
  TDDRH=record
   len,sub,cmd: Byte;
   status: Word;
   res: array[0..7] of Char;
   drv: Byte;
   ptr: Pointer;
   sec: LongInt;
  end;
 var
  ddr: TDDRH;
 begin
  FillChar(ddr,sizeof(ddr),0);
  ddr.len:=$1A;
  ddr.cmd:=Byte(s[0]);
  ddr.ptr:=s+2;
  Byte(ddr.sec):=Byte(s[1]);
  asm	push	ss
	pop	es
	lea	bx,[ddr]
	mov	cx,[drv]
	mov	ax,1510h
	stc
	int	2Fh
	mov	al,1
	sbb	al,0
	mov	[@Result],al
  end;
 end;

function toc(tic:Word):Word;
{returns time elapsed since taking tic, in steps of about 55 ms}
 begin
  {$Q-}
  toc:=Timer-tic;	{ignore any overflows here, these are intended!}
  {$Q+}
 end;

function CD_Status:Word;
 var
  s: array[0..6] of Char;
 begin
  StrCopy(s,#3#5#6);
  Ioctl(s);
  CD_Status:=PWord(s+3)^;
 end;

function CD_Eject:Boolean;
{As Name implies, ejects a CD from current drive; does some message outpus}
 const
  Drehstrich: array[0..3] of Char='\|/-';
 var
  t,tic:Word;
  dr: Integer;
 begin
  tic:=timer;
  Write('Ejecting ',Char(drv+Ord('A')),':');
  Ioctl(#12#2#1#0);		{unlock door if locked (for disc changers)}
  CD_Eject:=Ioctl(#12#1#0);
  {Assume that every eject must take at least 1.5 seconds.
   Some implementations of CD drivers return control immediately,
   and door status will not immediately return OPEN, this confuses.}
  repeat Idle until toc(tic)>25;
  {Win95 CD driver does not return OPEN even if is, to get right state,
   you have to query seldom enough - therefore, this "self-lenging"
   wait loop between two Ioctls}
  dr:=0; t:=1;
  repeat
   tic:=timer;
   repeat Idle until toc(tic)>=t;
   Write(Drehstrich[dr],#8);
   dr:=(dr+1)mod 4;
   Inc(t,t);			{twice idle time to wait (Win95 requires)}
  until CD_Status and 1 <>0;	{until drive reports an open door!}
  Write(#13,#13:13);
 end;

function CD_WaitForClose:Boolean;
{An interactive waiting for next CD. If user does insert no CD, program
 stops. If there is a closed door without a CD at first call, this routine
 opens the tray. The insertion notification message will be animated.}
 label restart;
 var
  i,v:Integer;
  tic,sta: Word;
 begin
restart:
  sta:=CD_Status;
  if sta and 1 <>0 then begin
   {$Q-}
   contmode:=true;
   i:=60; v:=1;
   repeat
    tic:=timer;
    Write('Insert next CD, or no CD if you want to terminate. '#13:i);
    Inc(i,v);
    if i=79 then v:=-1;
    if i=53 then v:=1;
    repeat Idle until toc(tic)>=3;	{do not ask too often}
    sta:=CD_Status;
   until sta and 1 =0;			{until drive reports a closed door}
   tic:=timer;
   repeat Idle until toc(tic)>1*18;	{wait some seconds}
   Write(#13:79);
   {$Q+}
  end;
  if sta and $800 <>0 then begin
   if contmode then begin
    WriteLn('No CD in drive ',Char(drv+Ord('A')),':, aborting program now.');
    halt;
   end else begin
    CD_Eject;
    goto restart;
   end;
  end;
 end;


function MapBytes(Nr,len:LongInt):PChar;
{Like true memory mapping, this routine returns a pointer to loaded
 sectors. <len> of longint is for dreaming. This routine memorize sze
 of block two bytes below the returned pointer.}
 var P:PChar;
 begin
  if len>($10000-2048) then begin
   WriteLn('Too large (>=64K) directory structure to map, aborting!');
   RunError(220);
  end;
  Inc(LongRec(len).lo,2);
  GetMem(P,LongRec(len).lo);
  if not ReadSectors(P+2,LongRec(len).lo shr 11,Nr) then begin
   WriteLn('Cannot read sectors from CD drive, aborting!');
   RunError(221);
  end;
  PWord(P)^:=LongRec(len).lo;
  MapBytes:=P+2;
 end;

procedure UnmapBytes(p:PChar);
{Frees memory, uses the memorized size, therefore, acts as free() C function}
 begin
  Dec(p,2);
  FreeMem(p,PWord(p)^);
 end;

type
 ee=(le,be);
 bedw=array[ee] of LongInt;
 bew=array[ee] of Word;
 PDirEnt=^TDirEnt;
 TDirEnt=record
  r: Byte;	{the number of bytes in the record (which must be even)}
  ea: Byte;	{0 [number of sectors in extended attribute record]}
  file_start_lbn: bedw;		{Logical Block Number (=sector) of file start}
  file_size_byte: bedw;		{file length in bytes}
  date_time: array[0..6] of Byte;
  bit_flags: Byte;
  interleave_size: Byte;		{interleave size}
  interleave_skip: Byte;		{interleave skip factor}
  volume_set_number: bew;		{volume set sequence number}
  filename: String;		{a Pascal string!}
 end;

procedure uni2oem(w:Word;var s:PChar);
{too easy conversion yet, better solution asks resident DOSLFN}
 begin
  s^:=Char(w);
  Inc(s);
 end;

procedure ununi(d:PChar;s:PWord; l:Integer);
{copies l Unicode characters from s to d}
 begin
  while l<>0 do begin
   uni2oem(Swap(s^),d);
   Inc(s);
   dec(l);
  end;
 end;

procedure ununicode(var s:String);
{A quick-and-dirty unicode-to-ascii conversion; unicode data is big endian}
 var
  i: Integer;
 begin
  if odd(length(s)) then exit;
  Byte(s[0]):=length(s) div 2;
  ununi(@s[1],PWord(@s[1]),Byte(s[0]));
 end;

function IsRegularDir(de:TDirEnt): Boolean;
 begin
  with de do begin
   IsRegularDir:=(bit_flags and 2 <>0)	{Verzeichnis}
     and (filename<>#0)
     and (filename<>#1)	{nicht . und ..}
  end;
 end;

function IsBadDirEnt(de:PDirEnt): Boolean;
 begin
  with de^ do begin
   IsBadDirEnt:=odd(r) or (ea<>0) or (r<Length(filename)+33);
  end;
 end;


type
 PScanStatus=^TScanStatus;
 TScanStatus=record
  start_sec, start_len: LongInt;
  cur_len: LongInt;
  sec: PChar;
  de: PDirEnt;
 end;

procedure ShowRead;
 const
  Drehstrich: array[0..3] of Char='\|/-';
  dr: Integer=0;
 begin
  if verbosity=0 then exit;
  {if not isatty(1) then exit;}
  write(Drehstrich[dr],#13);
  dr:=(dr+1)mod 4;
 end;

procedure Scan_Init(var ss:TScanStatus; ssec,slen:LongInt);
 begin
  ss.start_sec:=ssec;
  ss.start_len:=slen;
  ss.cur_len:=slen;
  ss.sec:=MapBytes(ssec,slen);	{read in whole structure, we have lot space}
  ss.de:=PDirEnt(ss.sec);
  ShowRead;
 end;

procedure Scan_Next_DirEnt(var ss:TScanStatus);
{moves ss.de to the next directory entry,
 and wraps to begin if end is reached}
 begin
  with ss do begin
   with de^ do begin
    Inc(PChar(de),r);
    Dec(cur_len,r);
   end;
   if (cur_len=0) or IsBadDirEnt(de) then begin
    cur_len:=start_len;
    de:=PDirEnt(sec);
   end;
  end;
 end;

function Scan_Suche_Datei(var ss:TScanStatus; lookfor: LongInt):Boolean;
{seaches a file with "lookfor" sector in ss in round-robin manner}
 var
  sde: PDirEnt;	{Rundenspeicher}
 begin
  with ss do begin
   Scan_Suche_Datei:=false;
   sde:=de;
   repeat
    if (de^.bit_flags and 2 =0)	{sollte in der Regel sofort treffen!}
    and (de^.file_start_lbn[le]=lookfor)
    then begin
     Scan_Suche_Datei:=true;
     exit;
    end;
    Scan_Next_DirEnt(ss);
   until sde=de;
  end;
 end;

function Scan_Suche_Vrz(var ss:TScanStatus):Boolean;
{searches next directory in ss, round-robin}
 var
  sde: PDirEnt;	{Rundenspeicher}
 begin
  Scan_Suche_Vrz:=false;
  sde:=ss.de;
  repeat
   if IsRegularDir(ss.de^)
   then begin
    Scan_Suche_Vrz:=true;
    exit;
   end;
   Scan_Next_DirEnt(ss);
  until sde=ss.de;
 end;

procedure Scan_Done(var ss:TScanStatus);
 begin
  UnmapBytes(ss.sec);	{free memory}
 end;

var
 Num_Links: LongInt;
 LTab,STab: array[0..$0FFF] of LongInt;	{link data (max. 16K)}

function InSTab(k:LongInt):Boolean;
{D: Checks whether <k> is already in STab}
 var
  i: Integer;
 begin
  InSTab:=false;
  if LongRec(k).hi<>0 then exit;
  for i:=0 to Num_Links-1 do begin
   if STab[i]=LongRec(k).lo then begin
    InSTab:=true;
    exit;
   end;
  end;
 end;

procedure DisplayMatch(lsec,ssec:LongInt;
  lname,sname:string; depth:Byte; const comment:string);
 begin
  if Verbosity=0 then exit;
  if 35-depth-length(lname)<0 then begin
   lname:=copy(lname,1,35-depth-3)+'...';
  end;
  if 8-length(sname)<0 then begin
   sname:=copy(sname,1,8-3)+'...';
  end;
  Write('':depth,lname,'':35-depth-length(lname),lsec:6,
     ' <=> ',sname,'':8-length(sname),ssec:6,' (',comment,')');
  if Verbosity>=2 then writeln else write('':15-length(comment),#13);
  if depth>1 then begin		{don't write the useless root link}
   LTab[Num_Links]:=lsec;
   STab[Num_Links]:=ssec;
   Inc(Num_Links);
  end;
 end;

function Count_DirEnts(p:PDirEnt;l:LongInt):LongInt;
{D: Counts files and subdirs in p separately
 O: LOWORD=number of files
    HIWORD=number of subdirs, not counting . and ..}
 var
  cnt: LongRec;
 begin
  cnt.lo:=0;
  cnt.hi:=Word(-2);
  while (l<>0) and (not IsBadDirEnt(p)) do with p^ do begin
   if bit_flags and 2 =0
   then Inc(cnt.lo)
   else Inc(cnt.hi);
   Inc(PChar(p),r);
   Dec(l,r);
  end;
  Count_DirEnts:=LongInt(cnt);
 end;

function Locate_File(p:PDirEnt;l,lbn:LongInt):PDirEnt;
{D: Searches for a file matching <lbn>, or first file if <lbn>=0
 O: matched DirEnt, nil when not found}
 begin
  Locate_File:=nil;
  while (l<>0) and (not IsBadDirEnt(p)) do with p^ do begin
   if (bit_flags and 2 =0)
   and ((lbn=0) or (file_start_lbn[le]=lbn)) then begin
    Locate_File:=p;
    exit;
   end;
   Inc(PChar(p),r);
   Dec(l,r);
  end;
 end;

function MakeDirLink(lsec,llen,ssec,slen:LongInt;
  const lname,sname:string; depth, ldetect:Byte):Byte;
{possible return values:
 * 0 = Empty directory (this may be propagated)
 * 1 = No Match (sure)
 * 255 = Match (sure)
 * graduated "don't know exactly": all values between 2 and 254}
 label exi;
 var
  lbuf:PChar;
  lde,sde: PDirEnt;
  ss: TScanStatus;
{  ndetect: Byte;}
  lcount:LongInt;	{counter for directories and files}
 begin
  lbuf:=MapBytes(lsec,llen);	{read entire LFN directory}
  lde:=PDirEnt(lbuf);
  Scan_Init(ss,ssec,slen);	{read entire SFN directory, prepare search}
  lcount:=Count_DirEnts(lde,llen);
  if ldetect=255 then begin
   DisplayMatch(lsec,ssec,lname,sname,depth,'known');
   if lcount=0 then goto exi;	{return immediately if CD is completely empty}
  end else begin
   {Check #1: Number of directories and files must be the same}
   if lcount<>Count_DirEnts(ss.de,ss.cur_len) then begin
    ldetect:=1;
    goto exi;
   end;
   {Check #2: If there is no DirEnt at all, it is an empty directory.
    Because empty dir is an empty dir, eventually wrong linkage
    due to wrong order does not bother. Return 0}
   if lcount=0 then begin
    DisplayMatch(lsec,ssec,lname,sname,depth,'EMPTY');
    goto exi;
   end;
   {Check #3: If there are files, there must exist direct companions.
    Only one file is checked here; if matching, MakeDirLink return 255}
   if LongRec(lcount).lo<>0 then begin
    sde:=Locate_File(lde,llen,0);{return NIL is internal error}
    if Locate_File(ss.de,ss.cur_len,sde^.file_start_lbn[le])<>nil then begin
     ldetect:=255;		{A match is now sure}
     DisplayMatch(lsec,ssec,lname,sname,depth,'contain file');
    end else begin
     ldetect:=1;
     goto exi;
    end;
   end;
  end;
  {Check #4: If there is no subtree, return with ldetect, which
   must be 255 when no subtree is there due to program logic.}
  if LongRec(lcount).hi=0 then goto exi;
  {Check #5 and recursion: Do with all subdirs, but propagate 1}
  if ldetect=0 then ldetect:=1;
  while (llen<>0) and (not IsBadDirEnt(lde)) do begin
   if IsRegularDir(lde^) then begin
    UnUnicode(lde^.filename);	{needed for display and sorting}
    Scan_Suche_Vrz(ss);		{seek to first (or next) DirEnt}
    sde:=ss.de;			{start round-robin search}
    repeat
{For speed, SFN directories that are already in the list should not
 scanned again}
     if not InSTab(ss.de^.file_start_lbn[le])
     then case MakeDirLink(lde^.file_start_lbn[le],lde^.file_size_byte[le],
       ss.de^.file_start_lbn[le],ss.de^.file_size_byte[le],
       lde^.filename,ss.de^.filename,depth+1,0) of
      0: begin
       ldetect:=0;
       break;		{silence on empty subtrees}
      end;
      255: begin	{Callee has a match}
{If we had no match from files, now we can match due to matching subtree.
 The inner loop can be exited}
       if ldetect<>255 then begin
	DisplayMatch(lsec,ssec,lname,sname,depth,'subtree');
	ldetect:=255;
       end;
       break;		{exit search loop, subtree had given out the match}
      end;
     end{case};
     Scan_Next_DirEnt(ss);
     Scan_Suche_Vrz(ss);
    until sde=ss.de;
   end;
   Scan_Next_DirEnt(ss);
   Inc(PChar(lde),lde^.r);
   Dec(llen,lde^.r);
  end;
  if ldetect=0 then begin
   DisplayMatch(lsec,ssec,lname,sname,depth,'EMPTY subtree');
  end;
exi:
  Scan_Done(ss);
  UnmapBytes(lbuf);
  MakeDirLink:=ldetect;
 end;


type
 PVolDesc=^TVolDesc;
 TVolDesc=record
  id: array[0..7] of Char;	{#n'CD001'#1#0, n=1,2,255}
  system_id: array[0..31] of Char;
  volume_id: array[0..31] of Char;
  zero1: array[0..7] of Byte;
  total_sec_number: bedw;
  joliet_id: array[0..31] of Char;
  volume_set_size: bew;		{1}
  volume_sequence_number: bew;	{1}
  sector_size: bew;		{2048}
  path_table_length: bedw;
  le_path_table_sec: LongInt;
  le_path_table_2_sec: LongInt;
  be_path_table_sec: LongInt;
  be_path_table_2_sec: LongInt;
  root_directory_record: array[0..33] of Byte;
  volume_set_id: array[0..127] of Char;
  publisher_id: array[0..127] of Char;
  data_preparer_id: array[0..127] of Char;
  application_id: array[0..127] of Char;
  copyright_file_id: array[0..36] of Char;
  abstract_file_id: array[0..36] of Char;
  bibliographical_file_id: array[0..36] of Char;
{      17      date and time of volume creation
       17      date and time of most recent modification
       17      date and time when volume expires
       17      date and time when volume is effective
	1      1
	1      0
      512      reserved for application use (usually zeros)
      653      zeros}
 end;

type
 PVD_info=^TVD_info;
 TVD_info=record
  dir_sec, dir_len:  LongInt;
 end;

procedure ScanVDInfo(sec:PChar; var vd: TVD_Info);
 begin
  with PVolDesc(sec)^ do begin
   with PDirEnt(@root_Directory_record)^ do begin
    vd.dir_sec:=file_start_lbn[le];
    vd.dir_len:=file_size_byte[le];
   end;
  end;
 end;

function MkVol8(S:PChar):NameStr;
{Assumes S is already right-trimmed}
 var
  i: Integer;
  h: array[0..8] of Char;
 begin
  i:=0;
  repeat
   case s^ of
    '0'..'9','A'..'Z','a'..'z': begin
     h[i]:=s^; Inc(i);		{take numbers and letters only}
    end;
    #0: break;			{leave repeat_until}
   end;
   Inc(s);
  until i=8;
  h[i]:=#0;
  MkVol8:=StrPas(h);
 end;

function TrimRight(S:PChar):String;
{Assumes that S has 32 characers, leaves S right trimmed}
 var
  i: Integer;
 begin
  for i:=31 downto 0 do begin
   if s[i] in [#0,' '] then s[i]:=#0 else break;
  end;
  TrimRight:=StrPas(S);
 end;

const
 link_id:array[0..37] of Char='CeQuadrat Joliet directory link table';

function ProcessDrive(d:Char):Boolean;
 label fe,eject;		{eject exit}
 type
  Apres=(_PVD,_SVD,_TVD,_LinkTable);
 var
  sec: PChar;			{on heap to preserve stack}
  present: set of Apres;
  i: Integer;
  tic: Word;
  l: LongInt;
  lvol,svol: string[32];	{CD volume strings}
  vol8: namestr;
  pvd,svd: TVD_Info;
  f: File;
 begin
  ProcessDrive:=false;
  drv:=Ord(d)-Ord('A');		{set global variable}
  if batchmode then CD_WaitForClose;
  Write('Drive ',d,': '); Flush(output);
  present:=[];
  tic:=timer;
  GetMem(sec,2048);
  for i:=0 to 10 do begin
   if not GetVToc(i,sec) then begin
    WriteLn('SKIP: Cannot read VTOC #',i);
    FreeMem(sec,2048);
    exit;
   end;
   if StrComp(sec+1,'CD001'#1)<>0 then begin
    WriteLn('SKIP: Wrong Volume Descriptor at #',i);
    goto fe;
   end;
   case sec[0] of
    #1: begin
     Include(present,_PVD);
     svol:=TrimRight(PVolDesc(sec)^.volume_id);
     vol8:=MkVol8(PVolDesc(sec)^.volume_id);
     ScanVDInfo(sec,pvd);
    end;
    #2: if PLongInt(sec+88)^=$00402F25 then begin	{Joliet signature}
     ScanVDInfo(sec,svd);
     ununi(PVolDesc(sec)^.volume_id,PWord(@PVolDesc(sec)^.volume_id),32);
     lvol:=TrimRight(PVolDesc(sec)^.volume_id);
     Include(present,_SVD);
    end;
    #255: begin
     Include(present,_TVD);
     break;			{leave "for" loop}
    end;
   end;
  end;
  Inc(i);
  if present<>[_PVD.._TVD] then begin
   WriteLn('SKIP: No valid Joliet Descriptor found');
   goto fe;
  end;
  Assign(f,vol8+'.JLT');	{.JLT stands for Joliet Link Table}
  if not ForceMode then begin	{don't look for CeQuadrat and present file}
   GetVToc(i,sec);
   if strcomp(sec,link_id)=0 then begin
    WriteLn('SKIP: found the "',link_id,'"');
    goto fe;
   end;
   {$I-}Reset(f,1);{$I+}
   if IOResult=0 then begin
    Close(f);
    WriteLn('SKIP: link table ',FileRec(f).name,' already present');
    goto fe;
   end;
  end;
  FreeMem(sec,2048);
	{now: action!}
  Num_Links:=0;
  writeln('Joliet_Name','LBN':21,' <=> ISO_Name   LBN (link_reason)');
  MakeDirLink(svd.dir_sec,svd.dir_len,pvd.dir_sec,pvd.dir_len,
    lvol,svol,1,255);
  if verbosity=1 then write(#13:79);	{79 spaces and 1 #13 character}
	{now save the result}
  write('Found ',Num_Links,' links');
  tic:=toc(tic) div 18;
  case tic of
   0:;				{do nothing}
   1: Write(' in one second');
   else Write(' in ',tic,' seconds');
  end;
  write(', now writing ',FileRec(f).name);
  l:=sizeof(LongInt);		{=4}
  Rewrite(f,l);			{all DWORDs}
  BlockWrite(f,l,1);		{first byte declares data size, 1, 2, or 4}
  BlockWrite(f,Num_Links,1);	{second element address depends on data size}
  BlockWrite(f,STab,Num_Links);
  BlockWrite(f,LTab,Num_Links);
  Close(f);
  WriteLn;
  goto eject;
fe:
  FreeMem(sec,2048);
eject:
  if batchmode then CD_Eject;
 end;

var
 drvs: array[0..26] of Char;	{MSCDEX drive letter list}

procedure setdrv; assembler;
 asm	mov	bx,0
	mov	ax,1500h
	int	2fh
	push	bx		{save count}
	 push	ds
	 pop	es
	 mov	bx,offset drvs
	 mov	ax,150Dh
	 int	2Fh
	pop	cx
@@l:	add	byte ptr [bx],'A'	{make letters}
	inc	bx
	loop	@@l
	mov	byte ptr [bx],0		{terminate list}
 end;

procedure Usage;
 begin
  WriteLn('MKLINK reads all Joliet CDs and creates Link Tables for use with DOSLFN');
  WriteLn('Options: /? Get Help, /f force mode, /v+ more verbose, /v- less verbose');
  WriteLn(#9' /b batch process (ejects CD, continues after inserting another CD)');
  WriteLn('Normal letters are drive letters to scan for (with or without colon :)');
  WriteLn('haftmann#software, Freeware 10/01');
  halt;
 end;

var
 sp,spa: PChar;
 i: integer;
 arg: array[0..7] of Char;
 newdrvs: array[0..26] of Char;
begin
 FileMode:=0;
 verbosity:=1;
 SetDrv;
 sp:=newdrvs;
 for i:=1 to GetArgCount do begin
  GetArgStr(arg,i,sizeof(arg));
  StrUpper(arg);
  spa:=arg;
  case spa^ of
   '-','/': repeat
    Inc(spa);
    case spa^ of
     'V': case spa[1] of
      '-': Dec(verbosity);
      else Inc(verbosity);
     end;
     'F': forcemode:=true;
     'B': batchmode:=true;
     #0:  break;			{exit the REPEAT-UNTIL loop}
     else Usage;			{wrong or -h parameter given}
    end;
   until false;
   'A'..'Z': repeat
    if (not forcemode) and (StrScan(drvs,spa^)=nil) then begin
     WriteLn('Drive ',arg[0],': is not a CDROM drive, ignoring it');
    end else begin
     sp^:=spa^; Inc(sp);
    end;
    Inc(spa);
    if spa^=':' then Inc(spa);
    if not (spa^ in [#0,'A'..'Z']) then Usage;	{letters must follow}
   until spa^=#0;
   else Usage;
  end;
 end;
 if sp<>newdrvs then StrCopy(drvs,newdrvs);	{copy user preference}

 repeat
  sp:=drvs;
  while sp^<>#0 do begin
   ProcessDrive(sp^);
   Inc(sp);
  end;
 until not batchmode;
end.

(*
		   ISO9660 Simplified for DOS/Windows

			 by Philip J. Erdelsky
		       75746.3411@compuserve.com
		   http://www.alumni.caltech.edu/~pje/

1. Introduction

We weren't sure about it a few years ago, but by now it should be clear
to everyone that CD-ROM's are here to stay. Most PC's are equipped with
CD-ROM readers, and most major PC software packages are being
distributed on CD-ROM's.

Under DOS (and Windows, which uses the DOS file system) files are
written to both hard and floppy disks with a so-called FAT (File
Allocation Table) file system.

Files on a CD-ROM, however, are written to a different standard, called
ISO9660. ISO9660 is rather complex and poorly written, and obviously
contains a number of diplomatic compromises among advocates of DOS,
UNIX, MVS and perhaps other operating systems.

The simplified version presented here includes only features that would
normally be found on a CD-ROM to be used in a DOS system and which are
supported by the Microsoft MS-DOS CD-ROM Extensions (MSCDEX). It is
based on ISO9660, on certain documents regarding MSCDEX (version 2.10),
and on the contents of some actual CD-ROM's.

Where a field has a specific value on a CD-ROM to be used with DOS, that
value is given in this document. However, in some cases a brief
description of values for use with other operating systems is given in
square brackets.

ISO9660 makes provisions for sets of CD-ROM's, and apparently even
permits a file system to span more than one CD-ROM. However, this
feature is not supported by MSCDEX.


3. Files

The directory structure on a CD-ROM is almost exactly like that on a DOS
floppy or hard disk. (It is presumed that the reader of this document is
reasonably familiar with the DOS file system.) For this reason, DOS and
Windows applications can read files from a CD-ROM just as they would
from a floppy or hard disk.

There are only a few differences, which do not affect most applications:

     (1) The root directory contains the notorious "." and ".." entries,
	 just like any other directory.

     (2) There is no limit, other than disk capacity, to the size of the
         root directory.

     (3) The depth of directory nesting is limited to eight levels,
         including the root. For example, if drive E: contains a CD-ROM,
         a file such as E:\D2\D3\D4\D5\D6\D7\D8\FOO.TXT is permitted but
         E:\D2\D3\D4\D5\D6\D7\D8\D9\FOO.TXT is not.

     (4) If a CD-ROM is to be used by a DOS system, file names and
	 extensions must be limited to eight and three characters,
         respectively, even though ISO9660 permits longer names and
         extensions.

     (5) ISO9660 permits only capital letters, digits and underscores in
         a file or directory name or extension, but DOS also permits a
         number of other punctuation marks.

     (6) ISO9660 permits a file to have an extension but not a name, but
         DOS does not.

     (7) DOS permits a directory to have an extension, but ISO9660 does
         not.

     (8) Directories on a CD-ROM are always sorted, as described below.

Of course, neither DOS, nor UNIX, nor any other operating system can
WRITE files to a CD-ROM as it would to a floppy or hard disk, because a
CD-ROM is not rewritable. Files must be written to the CD-ROM by a
special program with special hardware.


4. Sectors

The information on a CD-ROM is divided into sectors, which are numbered
consecutively, starting with zero. There are no gaps in the numbering.

Each sector contains 2048 8-bit bytes. (ISO9660 apparently permits other
sector sizes, but the 2048-byte size seems to be universal.)

When a number of sectors are to be read from the CD-ROM, they should be
read in order of increasing sector number, if possible, since that is
the order in which they pass under the read head as the CD-ROM rotates.
Most implementations arrange the information so sectors will be read in
this order for typical file operations, although ISO9660 does not
require this in all cases.

The order of bytes within a sector is considered to be the order in
which they appear when read into memory; i.e., the "first" bytes are
read into the lowest memory addresses. This is also the order used in
this document; i.e., the "first" bytes in any list appear at the top of
the list.


5. Character Sets

Names and extensions of files and directories, the volume name, and some
other names are expressed in standard ASCII character codes (although
ISO9660 does not use the name ASCII). According to ISO9660, only capital
letters, digits, and underscores are permitted. However, DOS permits
some other punctuation marks, which are sometimes found on CD-ROM's, in
apparent defiance of ISO9660.

MSCDEX does offer support for the kanji (Japanese) character set.
However, this document does not cover kanji.


6. Sorting Names or Extensions

Where ISO9660 requires file or directory names or extensions to be
sorted, the usual ASCII collating sequence is used. That is, two
different names or extensions are compared as follows:

     (1) ASCII blanks (32) are added to the right end of the shorter
	 name or extension, if necessary, to make it as long as the
	 longer name or extension.

     (2) The first (leftmost) position in which the names or extensions
	 are not identical determines the order. The name or extension
	 with the lower ASCII code in that position appears first in the
	 sorted order.


7. Multiple-Byte Values

A 16-bit numeric value (usually called a word) may be represented on a
CD-ROM in any of three ways:

     Little Endian Word: The value occupies two consecutive bytes, with
       the less significant byte first.

     Big Endian Word: The value occupies two consecutive bytes, with
       the more significant byte first.

     Both Endian Word: The value occupies FOUR consecutive bytes; the
       first and second bytes contain the value expressed as a little
       endian word, and the third and fourth bytes contain the same
       value expressed as a big endian word.

A 32-bit numeric value (usually called a double word) may be represented
on a CD-ROM in any of three ways:

     Little Endian Double Word: The value occupies four consecutive
       bytes, with the least significant byte first and the other bytes
       in order of increasing significance.

     Big Endian Double Word: The value occupies four consecutive bytes,
       with the most significant first and the other bytes in order of
       decreasing significance.

     Both Endian Double Word: The value occupies EIGHT consecutive
       bytes; the first four bytes contain the value expressed as a
       little endian double word, and the last four bytes contain the
       same value expressed as a big endian double word.


8. The First Sixteen Sectors are Empty

The first sixteen sectors (sector numbers 0 to 15, inclusive) contain
nothing but zeros. ISO9660 does not define the contents of these
sectors, but for DOS they are apparently always written as zeros.
They are apparently reserved for use by systems that can be booted from
a CD-ROM.


9. The Volume Descriptors

Sector 16 and a few of the following sectors contain a series of volume
descriptors. There are several kinds of volume descriptor, but only two
are normally used with DOS. Each volume descriptor occupies exactly one
sector.

The last volume descriptors in the series are one or more Volume
Descriptor Set Terminators. The first seven bytes of a Volume Descriptor
Set Terminator are 255, 67, 68, 48, 48, 49 and 1, respectively. The
other 2041 bytes are zeros. (The middle bytes are the ASCII codes for
the characters CD001.)

The only volume descriptor of real interest under DOS is the Primary
Volume Descriptor. There must be at least one, and there is usually only
one. However, some CD-ROM's have two or more identical Primary Volume
Descriptors. The contents of a Primary Volume Descriptor are as follows:

     length
     in bytes  contents
     --------  ---------------------------------------------------------
        1      1
        6      67, 68, 48, 48, 49 and 1, respectively (same as Volume
                 Descriptor Set Terminator)
        1      0
       32      system identifier
       32      volume identifier
        8      zeros
        8      total number of sectors, as a both endian double word
       32      zeros
        4      1, as a both endian word [volume set size]
        4      1, as a both endian word [volume sequence number]
        4      2048 (the sector size), as a both endian word
	8      path table length in bytes, as a both endian double word
        4      number of first sector in first little endian path table,
                 as a little endian double word
        4      number of first sector in second little endian path table,
		 as a little endian double word, or zero if there is no
		 second little endian path table
	4      number of first sector in first big endian path table,
		 as a big endian double word
	4      number of first sector in second big endian path table,
		 as a big endian double word, or zero if there is no
		 second big endian path table
       34      root directory record, as described below
      128      volume set identifier
      128      publisher identifier
      128      data preparer identifier
      128      application identifier
       37      copyright file identifier
       37      abstract file identifier
       37      bibliographical file identifier
       17      date and time of volume creation
       17      date and time of most recent modification
       17      date and time when volume expires
       17      date and time when volume is effective
        1      1
        1      0
      512      reserved for application use (usually zeros)
      653      zeros

The first 11 characters of the volume identifier are returned as
the volume identifier by standard DOS system calls and utilities.

Other identifiers are not used by DOS, and may be filled with ASCII
blanks (32).

Each date and time field is of the following form:

     length
     in bytes  contents
     --------  ---------------------------------------------------------
        4      year, as four ASCII digits
        2      month, as two ASCII digits, where
                 01=January, 02=February, etc.
	2      day of month, as two ASCII digits, in the range
                 from 01 to 31
        2      hour, as two ASCII digits, in the range from 00 to 23
	2      minute, as two ASCII digits, in the range from 00 to 59
        2      second, as two ASCII digits, in the range from 00 to 59
        2      hundredths of a second, as two ASCII digits, in the range
		 from 00 to 99
        1      offset from Greenwich Mean Time, in 15-minute intervals,
                 as a twos complement signed number, positive for time
		 zones east of Greenwich, and negative for time zones
                 west of Greenwich

If the date and time are not specified, the first 16 bytes are all ASCII
zeros (48), and the last byte is zero.

Other kinds of Volume Descriptors (which are normally ignored by DOS)
have the following format:

     length
     in bytes  contents
     --------  ---------------------------------------------------------
        1      neither 1 nor 255
        6      67, 68, 48, 48, 49 and 1, respectively (same as Volume
                 Descriptor Set Terminator)
      2041     other things


10. Path Tables

The path tables normally come right after the volume descriptors.
However, ISO9660 merely requires that each path table begin in the
sector specified by the Primary Volume Descriptor.

The path tables are actually redundant, since all of the information
contained in them is also stored elsewhere on the CD-ROM. However, their
use can make directory searches much faster.

There are two kinds of path table -- a little endian path table, in
which multiple-byte values are stored in little endian order, and a big
endian path table, in which multiple-byte values are stored in big
endian order. The two kinds of path tables are identical in every other
way.

A path table contains one record for each directory on the CD-ROM
(including the root directory). The format of a record is as follows:

     length
     in bytes  contents
     --------  ---------------------------------------------------------
	1      N, the name length (or 1 for the root directory)
	1      0 [number of sectors in extended attribute record]
	4      number of the first sector in the directory, as a
		 double word
	2      number of record for parent directory (or 1 for the root
		 directory), as a word; the first record is number 1,
		 the second record is number 2, etc.
	N      name (or 0 for the root directory)
      0 or 1   padding byte: if N is odd, this field contains a zero; if
		 N is even, this field is omitted

According to ISO9660, a directory name consists of at least one and not
more than 31 capital letters, digits and underscores. For DOS the upper
limit is eight characters.

A path table occupies as many consecutive sectors as may be required to
hold all its records. The first record always begins in the first byte
of the first sector. Except for the single byte described above, no
padding is used between records; hence the last record in a sector is
usually continued in the next following sector. The unused part of the
last sector is filled with zeros.

The records in a path table are arranged in a precisely specified order.
For this purpose, each directory has an associated number called its
level. The level of the root directory is 1. The level of each other
directory is one greater than the level of its parent. As noted above,
ISO9660 does not permit levels greater than 8.

The relative positions of any two records are determined as follows:

     (1) If the levels are different, the directory with the lower level
	 appears first. In particular, this implies that the root
         directory is always represented by the first record in the
         table, because it is the only directory with level 1.

     (2) If the levels are identical, but the directories have different
         parents, then the directories are in the same relative
         positions as their parents.

     (3) Directories with the same level and the same parent are
         arranged in the order obtained by sorting on their names, as
         described in Section 6.


11. Directories

A directory consists of a series of directory records in one or more
consecutive sectors. However, unlike path records, directory records may
not straddle sector boundaries. There may be unused space at the end of
each sector, which is filled with zeros.

Each directory record represents a file or directory. Its format is as
follows:

     length
     in bytes  contents
     --------  ---------------------------------------------------------
	1      R, the number of bytes in the record (which must be even)
	1      0 [number of sectors in extended attribute record]
	8      number of the first sector of file data or directory
		 (zero for an empty file), as a both endian double word
	8      number of bytes of file data or length of directory,
		 excluding the extended attribute record,
		 as a both endian double word
	1      number of years since 1900
	1      month, where 1=January, 2=February, etc.
	1      day of month, in the range from 1 to 31
	1      hour, in the range from 0 to 23
	1      minute, in the range from 0 to 59
	1      second, in the range from 0 to 59
		 (for DOS this is always an even number)
	1      offset from Greenwich Mean Time, in 15-minute intervals,
		 as a twos complement signed number, positive for time
		 zones east of Greenwich, and negative for time zones
		 west of Greenwich (DOS ignores this field)
	1      flags, with bits as follows:
                 bit     value
                 ------  ------------------------------------------
                 0 (LS)  0 for a norma1 file, 1 for a hidden file
                 1       0 for a file, 1 for a directory
                 2       0 [1 for an associated file]
		 3       0 [1 for record format specified]
                 4       0 [1 for permissions specified]
                 5       0
                 6       0
                 7 (MS)  0 [1 if not the final record for the file]
        1      0 [file unit size for an interleaved file]
        1      0 [interleave gap size for an interleaved file]
        4      1, as a both endian word [volume sequence number]
	1      N, the identifier length
	N      identifier
        P      padding byte: if N is even, P = 1 and this field contains
                 a zero; if N is odd, P = 0 and this field is omitted
    R-33-N-P   unspecified field for system use; must contain an even
                 number of bytes

The length of a directory includes the unused space, if any, at the ends
of sectors. Hence it is always an exact multiple of 2048 (the sector
size). Since every directory, even a nominally empty one, contains at
least two records, the length of a directory is never zero.

All fields in the first record (sometimes called the "." record) refer
to the directory itself, except that the identifier length is 1, and the
identifier is zero. The root directory record in the Primary Volume
Descriptor also has this format.

All fields in the second record (sometimes called the ".." record) refer
to the parent directory, except that the identifier length is 1, and the
identifier is 1. The second record in the root directory refers to the
root directory.

The identifier for a subdirectory is its name. The identifier for a file
consists of the following fields, in the order given:

     (1) The name, consisting of the ASCII codes for at least one and
         not more than eight capital letters, digits and underscores.

     (2) If there is an extension, the ASCII code for a period (46). If
         there is no extension, this field is omitted.

     (3) The extension, consisting of the ASCII codes for not more than
         three capital letters, digits and underscores. If there is no
         extension, this field is omitted.

     (4) The ASCII code for a semicolon (59).

     (5) The ASCII code for 1 (49). [On other systems, this is the
         version number, consisting of the ASCII codes for a sequence of
         digits representing a number between 1 and 32767, inclusive.]

Some implementations for DOS omit (4) and (5), and some use punctuation
marks other than underscores in file names and extensions.

Directory records other than the first two are sorted as follows:

     (1) Records are sorted by name, as described above.

     (2) Every series of records with the same name is sorted by
         extension, as described above. For this purpose, a record
         without an extension is sorted as though its extension
         consisted of ASCII blanks (32).

     (3) [On other systems, every series of records with the same name
         and extension is sorted in order of decreasing version number.]

     (4) [On other systems, two records with the same name, extension
         and version number are permitted, if the first record is an
         associated file.]

[ISO9660 permits names containing more than eight characters and
extensions containing more than three characters, as long as both of
them together contain no more than 30 characters.]

It is apparently permissible under ISO9660 to use two or more
consecutive records to represent consecutive pieces of the same file.
Bit 7 of the flags byte is set in every record except the last one.
However, this technique seems pointless and is apparently not used. It
is not supported by MSCDEX.

Interleaving is another technique that is apparently seldom used. It is
not supported by MSCDEX (version 2.10).


12. Arrangement of Directory and Data Sectors

ISO9660 does not specify the order of directory or file sectors. It
merely requires that the first sector of each directory or file be in
the location specified by its directory record, and that the sectors for
directories and non-interleaved files be consecutive.

However, most implementations arrange the directories so each directory
follows its parent, and the data sectors for the files in each directory
lie immediately after the directory and immediately before the next
following directory. This appears to be an efficient arrangement for
most applications.

Some implementations go one step further and order the directories in
the same manner as the corresponding path table records.

*)