/* Telnet Server with Echo support
 *
 * Written by Tomohiro Haraikawa
 */
 
#include <string.h>
#include <stdio.h>
#include <io.h>

#include <dev/uartavr.h>
#include <dev/nicrtl.h>

#include <sys/version.h>
#include <sys/heap.h>
#include <sys/thread.h>
#include <sys/timer.h>
#include <sys/confnet.h>
#include <sys/socket.h>

#include <arpa/inet.h>
#include "telnet.h"
 
#define NVT_SE          240
#define NVT_SB          250
#define NVT_WILL        251
#define NVT_WONT        252
#define NVT_DO          253
#define NVT_DONT        254
#define NVT_IAC         255
#define NVT_OPT_ECHO      1
#define NVT_OPT_SGA       3

void nvt_session(FILE *stream, u_char req, u_char opt, u_char accept)
{
  u_char nvt[3] = { NVT_IAC, 0 };
  switch (req)
  {
    case NVT_WILL:
      nvt[1] = accept ? NVT_DO : NVT_DONT;
      break;
    case NVT_WONT:
      nvt[1] = NVT_DONT;
      break;
    case NVT_DO:
      nvt[1] = accept ? NVT_WILL : NVT_WONT;
      break;
    case NVT_DONT:
      nvt[1] = NVT_WONT;
  }
  if (!nvt[1]) return;
  nvt[2] = opt;
  fputc(nvt[0],stream);
  fputc(nvt[1],stream);
  fputc(nvt[2],stream);
  fflush(stream);
  return;
}

void telnet_session(TCPSOCKET *sock, int (*func)(char *p, FILE *stream), PGM_P banner)
{
	FILE *stream;
  u_char buff[128], ch = '\0', echo = 1, nvt = 0, nvt_sub = NVT_SE;
  const u_char lf = '\n';
  
  int eol, len;
  
  if(!(stream = _fdopen((int)sock, "r+b"))) return; /* Assigning stream failed */ 
  {
    if (banner) 
      fputs_P(banner,stream);
    else
      fputs("\r\nWelcome\r\n",stream);  
    do 
    {
    	fputs(">",stream);
      fflush(stream);
      len = 0;
      eol=1;
      do 
      {
        buff[len]=fgetc(stream);
        {
          if (nvt == NVT_IAC) 
          {
            nvt = 0;
            switch (buff[len]) 
            {
              case NVT_IAC:
                break;
              case NVT_SB:
              case NVT_SE:
                nvt_sub = buff[len];
                continue;
              case NVT_WILL:
              case NVT_WONT:
              case NVT_DO:
              case NVT_DONT:
                nvt = buff[len];
              default:
                continue;
            }
          }
          else
            if (nvt_sub == NVT_SB) 
            {
              nvt = (buff[len] == NVT_IAC) ? NVT_IAC : 0;
              continue;
            }
            else
              if (NVT_WILL <= nvt && nvt <= NVT_DONT) 
              {
                switch (buff[len]) 
                {
                  case NVT_OPT_ECHO:
                    echo = (nvt == NVT_DO || nvt == NVT_WONT);
                    nvt_session(stream, nvt, buff[len], 1);
                    break;
                  case NVT_OPT_SGA:
                    if (nvt == NVT_WILL || nvt == NVT_DO) 
                      nvt_session(stream, nvt, buff[len], 1);
                    else
                      nvt_session(stream, nvt, buff[len], 0);
                }
                nvt = 0;
                continue;
              }
              else
                if (buff[len] == NVT_IAC) 
                {
                  nvt = NVT_IAC;
                  continue;
                }
                
          if (echo)
          {
            if (buff[len] != '\n') fputc(buff[len],stream);
            if (buff[len] == '\r') fputc(lf, stream);
            fflush(stream);
          }
          switch (buff[len]) 
          {
            case 0x08:
            case 0x7f:
              if (len >= 1) len--;
              if (echo)
              {
              	fputc(' ',stream);
              	fputc(0x08,stream);
              	fflush(stream);
              }
            case '\0':
              continue;
            case '\n':
              if (ch == '\r') 
              {
                ch = buff[len];
                continue;
              }
              /* fall through */
            case '\r':
              eol = 0;
              /* fall through */
            default:
              ch = buff[len];
          }
        }
        if (++len >= (int)sizeof(buff) - 1) break;
      } while (eol > 0);
      buff[len--] = '\0';
      /* remove trailing end of line character */
      if ((buff[len]=='\r') || (buff[len]=='\n')) buff[len]=0;
      
      /* now buff contains a command line */
      if (func)
        len=(func(buff,stream)!=1);
      else
        puts(buff);
    } while (len);
    fclose(stream);
  }
}

