#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/ip_icmp.h>
#include <ctype.h>
#include <netdb.h>

int ping(char* hostname, char repeat, FILE* stream)
{
  u_long destIP;
  ICMPSOCKET* sock;
  u_char data[32];
  int i;

  if (hostname)
    if (!(destIP = NutDnsGetHostByName(hostname)))
    {
  	  fprintf(stream,"\nCannot resolve Hostname '%s'\n",hostname);
  	  free(buffer);
	    return 1;
	  }
	else
	  return 1;  
  
  sock = NutIcmpCreateSocket(IPPROTO_ICMP,1);
   
  fprintf_P(stream,PSTR("Pinging %s [%a] with 32 bytes\r\n\r\n"),hostname,destIP);
  fflush(stream);
   
  for( i = 0 ; i < repeat ; i++)
  {
    u_long reply_addr;
    u_char type;
    u_char code;
    u_long ticks;
       
    NutIcmpSendTo(sock,destIP,ICMP_ECHO,0,data,32);
    ticks = NutGetTickCount();
       
    if (NutIcmpReceiveFrom(sock,&reply_addr,&type,&code,data,32,3000) != 0)
    {
      switch(type)
      {
        case ICMP_ECHOREPLY:
          fprintf_P(stream,PSTR("Reply from %a %i ms\r\n"),reply_addr,(int)(((NutGetTickCount()-ticks)*1000)/ 40L));
          break;

        default:
          fprintf_P(stream,PSTR("Reply from %a type %i code %i\r\n"),reply_addr,type,code);
      }
    }
    else
    {
      fputs_P(PSTR("Request timed out.\r\n"),stream);
    }
           
    fflush(f);
  }
   
  NutIcmpDestroySocket(sock);
  return 0;
}

