#if !defined(LEDdotH)
#define LEDdotH

/* Display Size */
#define MAXX    256
#define MAXY    64

/* Colort constants */
#define BLACK   0
#define RED     1
#define GREEN   2
#define YELLOW  3

/* Text Allignment constants */
#define TE_LEFT        0
#define TE_CENTER      1
#define TE_RIGHT       2

extern char testmode;

/*
 * Startup Timer2 ISR for muxing the panel
 */
void startTimer(void);

/*
 * enable main power supply
 */
void LEDPowerOn(void);

/*
 * disable main power supply
 */
void LEDPowerOff(void);

/*
 * Get adress of current display buffer
 */
char *LEDGetbuffer(void);

/*
 * Initialize LED Matrix
 */
void LEDInit(void);

/* 
 * Clear Screen
 */
void LEDClear(void);

/*
 * Draw Pixel to VFD
 */
void LEDPixel(int x, int y, u_char c);

/*
 * Draw Line 
 */
void LEDLine(int x1,int y1,int x2,int y2, int c);

/*
 * Draw horizontal line to VFD
 */
void LEDHLine(int x, int y, u_int l, u_char c);

/* 
 * Draw vertical line to VFD
 */
void LEDVLine(int x, int y, u_int l, u_char c);

/*
 * Draw Rectangle to vfd
 */
void LEDRectangle(int x, int y, int w, int h, u_char c);

/*
 * Draw filled Rectangle to vfd
 */
void LEDFRectangle(int x, int y, int w, int h, u_char c);

/*
 * Draw string to VFD
 */
int LEDStr(int x, int y, u_char c, const char *s);

/*
 * Draw formatted string to VFD
 */
void LEDFStr(int x, int y, int w, int f, u_char c, const char *s);

/* 
 * Draw a Circle
 */
void LEDCircle(int x,int y,int r,int c);

/* 
 * Draw a filled Circle 
 */
void LEDFCircle(int x,int y,int r,int c);

/* 
 * Actualize Display
 */
void LEDDraw(void);

/*
 * calculate string length
 */
int LEDGetStrLength(const char *s);

/*
 * calculate string Height
 */
int LEDGetStrHeight(void);

#endif
