#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <avr/wdt.h>
#include <sys/timer.h>
#include <sys/version.h>
#include <sys/confnet.h>
#include <sys/socket.h>
#include <net/route.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <pro/dhcp.h>
#include "LEDMatrix.h"

#define stricmp strcasecmp

/*
 * show configuration
 */
void showConfigInfo(FILE *stream)
{
  fprintf_P(stream,vbanner_P, Version, NutVersionString());
  fprintf(stream,"\r\nCPU Frequency: %lu (%lu)\r\n",NutGetCpuClock(),NUT_CPU_FREQ);
  fprintf_P(stream,PSTR("TCP/IP Parameter\r\n"));
  fprintf_P(stream,PSTR("   MAC            : %02X-%02X-%02X-%02X-%02X-%02X\r\n"),
            confnet.cdn_mac[0], confnet.cdn_mac[1],confnet.cdn_mac[2], confnet.cdn_mac[3], confnet.cdn_mac[4], confnet.cdn_mac[5]);
  fprintf_P(stream,PSTR("   Adress         : %s%s\r\n"),inet_ntoa(confnet.cdn_ip_addr),confnet.cdn_cip_addr?"":" (DHCP)");
  fprintf_P(stream,PSTR("   Subnet Mask    : %s\r\n"),inet_ntoa(confnet.cdn_ip_mask));
  fprintf_P(stream,PSTR("   Default Gateway: %s\r\n"),inet_ntoa(confnet.cdn_gateway));
  fprintf_P(stream,PSTR("   Primary DNS    : %s\r\n"),inet_ntoa(doc.doc_ip1)); 
  fprintf_P(stream,PSTR("   Secondary DNS  : %s\r\n"),inet_ntoa(doc.doc_ip2)); 
  if (doc.doc_hostname && doc.doc_domain)
    fprintf_P(stream,PSTR("   Hostname       : %s.%s\r\n"),doc.doc_hostname,doc.doc_domain);
}

/*
 * set configuration value
 */
int set_config(char *varname, char *value, FILE *stream)
{
	char *s;
	
  if (!varname || !stricmp(varname,"help") || !stricmp(varname,"?"))
  {
    fputs_P(PSTR("\r\n"
                 "SET ADDR <IPADDRES>        set TCP/IP address (0.0.0.0 for DHCP)\r\n"
                 "SET MASK <SUBNETMASK>      set subnet mask\r\n"
                 "SET GATEWAY <IPADRESS>     set default gateway\r\n"
                 "SET DNS1 <IPADRESS>        set primary DNS server\r\n"
                 "SET DNS2 <IPADRESS>        set secondary DNS server\r\n"
                 "SET HOST <HOST>[.<DOMAIN>] set hostname and domain\r\n"
                 "SET MAC <MACADDRES>        set hardware address (use with care)\r\n"),stream);
    return 0;
  }

	if (!value) return 3;
	fprintf(stream," Var: <%s>    Val: <%s>\r\n",varname,value);
	
  if (!stricmp(varname,"addr"))
  {
    confnet.cdn_cip_addr=inet_addr(value);
    return 0;
  }

  if (!stricmp(varname,"mask"))
  {
    confnet.cdn_ip_mask=inet_addr(value);
    return 0;
  }

  if (!stricmp(varname,"gateway"))
  {
    confnet.cdn_gateway=inet_addr(value);
    return 0;
  }
  
  if (!stricmp(varname,"dns1"))
  {
    doc.doc_ip1=inet_addr(value);
    return 0;
  }
  
  if (!stricmp(varname,"dns2"))
  {
    doc.doc_ip2=inet_addr(value);
    return 0;
  }
  
  if (!stricmp(varname,"host"))
  {
  	if (doc.doc_hostname) free(doc.doc_hostname);
    s=strchr(value,'.');
    if (s)
    {
    	*s++=0;
    	if (doc.doc_domain) free(doc.doc_domain);
    	doc.doc_domain=malloc(strlen(s)+1);
    	if (!doc.doc_domain)
    	{
    		fputs_P(PSTR("Internal Error setting hostname"),stream);
    		return 2;
    	}
    	strcpy(doc.doc_domain,s);
    }
    doc.doc_hostname=malloc(strlen(value)+1);
  	if (!doc.doc_hostname)
  	{
   		fputs_P(PSTR("Internal Error setting hostname"),stream);
   		return 2;
   	}
   	strcpy(doc.doc_hostname,value);
    return 0;
  }
  return 4;
}  

/*
 * save configuration and reboot
 */
int save_config(FILE *stream)
{
	char c;
	fputs("About to save these settings:",stream);
	showConfigInfo(stream);
	fputs("Are you sure (y/n)",stream);
	fflush(stream);
	do
	{
	  c=fgetc(stream);
	}	while (c!='y' && c!='Y' && c!='n' && c!='N');
	if (c=='y' || c=='Y')
	{
		NutNetSaveConfig();
		fputs("...saved, rebooting",stream);
		fclose(stream);
		NutSleep(1000);
    cli();
    wdt_reset();
    wdt_enable(1);
    while(1);
	}
	return 0;
}
