/*
 * LED Matrix display driver (main function and tcpip routines)
 *
 * Controlling several LED Matrix Modules Samsung SLM1606M/SLM1608M
 * connected to port B/D of Ethernut:
 *
 * Printer   Module
 * -----------------
 * D0 (2)    SELECT (CN2-2)
 * D1 (3)    RED    (CN3-2)
 * D2 (4)    GREEN  (CN3-4)
 * D3 (6)    CLOCK  (CN3-6)
 * D4 (8)    BRIGHT (CN3-8)
 * D5 (9)    RESET  (CN3-10)
 * GND (20)  GND    (CN3-3)
 *
 * Written by Thorsten Erdmann 06/2003 (thorsten.erdmann@gmx.de)
 */

/**************************************************************
 **** CAUTION: The module can be destroyed if applied      ****
 ****          static signals, so NEVER interrupt the      ****
 ****          program without switching off module's      ****
 ****          power source first !!!                      ****
 **************************************************************/
#include <dev/nicrtl.h>
#include <dev/uartavr.h>
#include <sys/heap.h>
#include <sys/thread.h>
#include <sys/timer.h>
 
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <io.h>

#include <sys/version.h>
#include <sys/confnet.h>
#include <sys/socket.h>
#include <net/route.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <pro/dhcp.h>

const char *Version="1.0";
prog_char vbanner_P[]="\r\nLED Matrix Display - FW %s, Nut/OS %s\r\n";
prog_char banner_P[]="\r\nLED Matrix Display\r\nType 'help' for a list of available commands\r\n";

#include "led.h" 
#include "parser.h"
#include "telnet.h"
#include "config.h"

/*
 * read a line from a stream with echo and BS support
 */
void readln(char *line, u_char len, FILE *stream)
{
	u_char x=0;
  u_char ch;
  *line=0;
  do
  {
    ch=fgetc(stream);
    switch (ch)
    {
      case 0x08:
      case 0x7f:
        if (x>0)
        {
          line[--x]=0;
          fputc(ch,stream);
          fputc(' ',stream);
          fputc(ch,stream);
          fflush(stream);
        }
        break;
      default:
        if (ch>=' ')
        {
          if (x<len)
          {
            fputc(ch,stream);
            fflush(stream);
            line[x++]=ch;
            line[x]=0;
          }
        }
    }
  } while (ch!='\n');
}

/*
 * Telnet Server Thread
 */
THREAD(Telnet, arg)
{
  TCPSOCKET *sock; 
 
  /* loop endless for connections. */
  for(;;) 
  {
    /* Create a socket. */
	  if ((sock = NutTcpCreateSocket()) != 0) 
	  {
	    /* Listen on port 23. If we return, we got a client. */
	    if (NutTcpAccept(sock, 23) == 0) 
  	  	telnet_session(sock,Processline,banner_P);
      /* Close our socket. */
	    NutTcpCloseSocket(sock);
	  }
  }
}

THREAD(udpReceiver,arg)
{
  static UDPSOCKET *udpsock;
  static u_long  addr;
  static u_short port;
  static u_char  bufr[4096];
  int     size;
  static u_char  *src, *dest;
  static int     len;
  
  if ((udpsock=NutUdpCreateSocket(4950)))
  {
  	for (;;)
  	{
  		size=NutUdpReceiveFrom(udpsock, &addr, &port, bufr, 4096, 1000);
//   		if (size>0)	
//   		  printf("\n%i Bytes received from %s:%i : 0x%02x 0x%02x\n",size, inet_ntoa(addr),port,bufr[0],bufr[1]);

  		if ((size>1) && (*bufr==0x42))
  		{
  			if (bufr[1]&0x70)
  			{
  			  src=bufr+2;
  			  dest=LEDGetbuffer()+((bufr[1]&0x0f)<<4);
  			  len =bufr[1]&0x70;
  			  for (port=0;port<16;port++)
  			  {
  				  memcpy(dest,src,len);
  				  src+=len;
  				  dest+=256;
  			  }
  		  }
  		  else
  		  {
  		  	puts("ClearScr");
  		  	LEDClear();
  		  }
  			if (bufr[1]&0x80) LEDDraw();
  		}
  	}
  }
  else
    puts("Creation of UDP socket failed");
  for (;;);
}
  	
/*
 * prints a message to console and to display 
 */
void message(u_char c, char *line)
{
	static int y=0;
  LEDStr(0,y,c,line); 
  LEDDraw();
  y+=LEDGetStrHeight();
  puts(line);
}

/*
 * show configuration
 */
 /*
void showConfigInfo(FILE *stream)
{
	prog_char ippar_P[]=    
	  "\r\nTCP/IP Parameter\r\n"
    "   MAC            : %02X-%02X-%02X-%02X-%02X-%02X\r\n"
    "   Adress         : %s\r\n"
    "   Subnet Mask    : %s\r\n"
    "   Default Gateway: %s\r\n";
  fprintf(stream, ippar_P,confnet.cdn_mac[0], confnet.cdn_mac[1],confnet.cdn_mac[2], confnet.cdn_mac[3], confnet.cdn_mac[4], confnet.cdn_mac[5]
          ,inet_ntoa(confnet.cdn_cip_addr),inet_ntoa(confnet.cdn_ip_mask),inet_ntoa(confnet.cdn_gateway)); 
}
	 */
/*
 * Main application routine. 
 */
int main(void)
{
	char *line;
  u_long baud = 115200; 
  
  line=malloc(30);
  /*
   * Register the UART device, open it, assign stdout to it and set 
   * the baudrate.
   */ 
  NutRegisterDevice(&devUart0, 0, 0);
  
  freopen("uart0", "w", stdout);
  freopen("uart0", "r", stdin);
  _ioctl(_fileno(stdout), UART_SETSPEED, &baud);
  NutSleep(200);
  printf_P(vbanner_P, Version, NutVersionString());

  puts("Initialize LED Panel...");
  NutSleep(2000);

  LEDInit();
  puts("Timer started.");
  NutSleep(2000);
  LEDClear();
  sprintf(line,"LED Matrix Display - FW %s",Version);
  message(GREEN,line);
 
  message(RED,"Initialize Ethernet controller...");
  NutRegisterDevice(&devEth0, 0x8300, 5);
   
  message(RED,"Initialize TCP/IP...");
    NutRegisterDevice(&devEth0, 0x8300, 5);
   
 	printf_P(PSTR("Calling DHCP server..."));
  if (NutDhcpIfConfig("eth0", 0, 20000))
  {
    u_char my_mac[] = { 0x00,0x06,0x98,0x00,0x00,0x00 };
    if (NutDhcpIfConfig("eth0", my_mac, 20000)) 
    {
      printf_P(PSTR(" failed, using default settings"));
      NutNetIfConfig2("eth0", my_mac, inet_addr("192.168.100.48"), inet_addr("255.255.255.0"),inet_addr("0.0.0.0")); 
      //NutDnsConfig2("LEDPANEL", "", inet_addr("0.0.0.0"), 0);
    }
  }
  puts("");

  showConfigInfo(stdout);
  
  /* start Telnet server */
  message(RED,"Starting Telnet Server...");
  NutSleep(2000);
  NutThreadCreate("Telnet", Telnet, 0, 1024);

  /* start Telnet server */
  message(RED,"Starting UDP Server...");
  NutSleep(2000);
  NutThreadCreate("UDPRcv", udpReceiver, 0, 1024);

  /* now read lines from console and interpret it */
  message(GREEN,"System ready !");
  for (;;)
  {
  	printf("\n>");
  	readln(line,200,stdin);
    Processline(line,stdin);
  }
}
